IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_ENTRADA_AUTO_ERROS_VALIDACAO]'))
DROP VIEW [dbo].[V_ENTRADA_AUTO_ERROS_VALIDACAO]
GO

CREATE VIEW [dbo].[V_ENTRADA_AUTO_ERROS_VALIDACAO]  
as
--VERSAO 3302
 
	SELECT   
		e.CD_EMP,    
		CASE  WHEN O.DEST_ORIG = 0 THEN  
			DC1.CD_FILIAL
		WHEN O.DEST_ORIG = 1 THEN  
			DP1.CD_FILIAL  
		WHEN O.DEST_ORIG = 2 THEN  
			S.CD_CLI
		END CD_FILIAL, 
		
		e.CD_NF,   
		S.CD_FILIAL CD_DEST_ORIG,  
		F.RZ_FILIAL  DS_DEST_ORIG, 
		  
		S.NF_NF,  
		S.DT_EMI_NF,  
		S.VLR_NF,  
		S.STS_NF,  
		E.STS_ERRO,  
		e.ERROS_VALIDACAO.value('(list/br.itecbrazil.nfe.entidades.notasfiscais.Erro/erro)[1]','varchar(255)') Erro_1,  
		e.ERROS_VALIDACAO.value('(list/br.itecbrazil.nfe.entidades.notasfiscais.Erro/erro)[2]','varchar(255)') Erro_2,  
		e.ERROS_VALIDACAO.value('(list/br.itecbrazil.nfe.entidades.notasfiscais.Erro/erro)[3]','varchar(255)') Erro_3,  

		e.DT_CAD,  
		0 TP_ENTRADA_AUTO,  
		'TRANSFERENCIA ENTRE FILIAIS' DS_ENTRADA_AUTO  
	FROM   
		EST_NF_SAI_ERROS_VALIDACAO e  
		INNER JOIN EST_NF_SAI S ON   
		E.CD_EMP = S.CD_EMP AND  
		E.CD_FILIAL = S.CD_FILIAL AND  
		E.CD_NF  = S.CD_NF      
		
		INNER JOIN PRC_FILIAL F ON   
		E.CD_EMP = F.CD_EMP AND  
		E.CD_FILIAL = F.CD_FILIAL
		
		INNER JOIN GLB_MOV_OP O ON  
		S.CD_NT_MOV = O.CD_MOV_OP  

		LEFT JOIN RC_CLI DC ON   
		S.CD_EMP = DC.CD_EMP AND  
		S.CD_CLI = DC.CD_CLI 
		
		LEFT JOIN PRC_FILIAL_RC_CLI DC1 ON   
		DC.CD_EMP = DC1.CD_EMP AND  
		DC.CD_CLI = DC1.CD_CLI  

		LEFT JOIN PRC_FILIAL DF ON   
		S.CD_EMP = DF.CD_EMP AND  
		S.CD_CLI = DF.CD_FILIAL  

		LEFT JOIN PG_FORN DP ON    
		S.CD_CLI = DP.CD_FORN  
		
		LEFT JOIN PRC_FILIAL_PG_FORN DP1 ON    
		DP.CD_EMP  = DP1.CD_EMP AND
		DP.CD_FORN = DP1.CD_FORN  

	UNION ALL  
	SELECT   
		D.CD_EMP,  
		D.CD_FILIAL,  
		e.CD_CTR,  
		D.CD_FORN,  
		DP.RZ_FORN,  
		D.NR_NF,  
		D.DT_EMIS_NF ,  
		D.VLR_NF,  
		0 STS_NF,  
		E.STS_ERRO,  
		e.ERROS_VALIDACAO.value('(list/br.itecbrazil.nfe.entidades.notasfiscais.Erro/erro)[1]','varchar(255)') Erro_1,  
		e.ERROS_VALIDACAO.value('(list/br.itecbrazil.nfe.entidades.notasfiscais.Erro/erro)[2]','varchar(255)') Erro_2,  
		e.ERROS_VALIDACAO.value('(list/br.itecbrazil.nfe.entidades.notasfiscais.Erro/erro)[3]','varchar(255)') Erro_3,
		e.DT_CAD,  
		1 TP_ENTRADA_AUTO,  
		'NOTA DE ENTRADA DANFE FORNECEDOR' DS_ENTRADA_AUTO  
	FROM   
		EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO e  
		inner join EST_NF_ENT_DANFE_PROVISORIO  D on    
		E.CD_CTR = D.CD_CTR 
		
		LEFT JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT ED ON    
		D.CD_EMP	= ED.CD_EMP AND 
		D.CD_CTR	= ED.CD_CTR  AND 
		D.CD_FILIAL = ED.CD_FILIAL  

		LEFT JOIN PG_FORN DP ON    
		D.CD_FORN = DP.CD_FORN  
	WHERE  
		E.STS_ERRO = 0   
		AND ED.CD_EMP IS NULL
	UNION ALL  
	SELECT   
		e.CD_EMP,  
		e.CD_FILIAL,  
		e.CD_NF,  
		S.CD_FORN CD_DEST_ORIG,  
		CASE   
		WHEN O.DEST_ORIG = 0 THEN  
		DC.RZ_CLI  
		WHEN O.DEST_ORIG = 1 THEN  
		DP.RZ_FORN  
		WHEN O.DEST_ORIG = 2 THEN  
		DF.RZ_FILIAL  
		END DS_DEST_ORIG,  

		S.NR_NF,  
		S.DT_EMI_NF,  
		S.VLR_NF,  
		S.STS_NF,  
		E.STS_ERRO,  
		e.ERROS_VALIDACAO.value('(list/br.itecbrazil.nfe.entidades.notasfiscais.NotaFiscalErro/erro)[1]','varchar(255)') Erro_1,  
		e.ERROS_VALIDACAO.value('(list/br.itecbrazil.nfe.entidades.notasfiscais.NotaFiscalErro/erro)[2]','varchar(255)') Erro_2,  
		e.ERROS_VALIDACAO.value('(list/br.itecbrazil.nfe.entidades.notasfiscais.NotaFiscalErro/erro)[3]','varchar(255)') Erro_3,  
		e.DT_CAD,  
		2 TP_ENTRADA_AUTO,  
		'NOTA DE ENTRADA DAR' DS_ENTRADA_AUTO  
	FROM   
		EST_NF_ENT_DAR_ERROS_VALIDACAO e  
		INNER JOIN EST_NF_ENT S ON   
		E.CD_EMP = S.CD_EMP AND  
		E.CD_FILIAL = S.CD_FILIAL AND  
		E.CD_NF  = S.CD_NF      

		INNER JOIN GLB_MOV_OP O ON  
		S.CD_NT_MOV = O.CD_MOV_OP  

		LEFT JOIN RC_CLI DC ON   
		S.CD_EMP = DC.CD_EMP AND  
		S.CD_FORN = DC.CD_CLI  

		LEFT JOIN PRC_FILIAL DF ON   
		S.CD_EMP = DF.CD_EMP AND  
		S.CD_FORN = DF.CD_FILIAL  

		LEFT JOIN PG_FORN DP ON    
		S.CD_FORN = DP.CD_FORN  

